//
//  MCChangeManager.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 03/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


#import <Foundation/Foundation.h>


@class MCChangeSet;

@interface MCChangeManager : NSObject {

	NSString *baseDirectory;
	NSString *serverID;
	unsigned version;
	
	MCChangeSet *outgoingChanges;
	NSString *temporaryFolder;
	BOOL archiveChangeSets;
}

+ (NSString *)outgoingFolderName;


@property (readonly, copy) NSString *baseDirectory;
@property (readonly, copy) NSString *serverID;
@property (readonly) unsigned version;
@property (nonatomic, readwrite, retain) MCChangeSet *outgoingChanges;
@property (readwrite, copy) NSString *temporaryFolder;
@property (readwrite) BOOL archiveChangeSets;

// designated initializer
// calling -init will throw an exception
// this is an abstract class, so you probably want to allocaate a subclass
// base directory should be an absolute path; it will be created if necessary
- (id)initWithBaseDirectory:(NSString *)dirPath
				 databaseID:(NSString *)dbUUID
					version:(unsigned)aVersion;

- (NSString *)changeSetsFolder;

- (NSString *)outgoingChangeSetFolder;

// paths are generated using a unique name based on the date and the correct folder based on the clientID
- (NSString *)uniqueOutgoingChangeSetPath;

// these factories use the above path factories to create the new change set with its database in a valid location
- (MCChangeSet *)newAutoreleasedOutgoingChangeSet;

- (NSString *)uniqueTempChangeSetPath;
- (MCChangeSet *)newAutoreleasedTempChangeSet;

+ (NSString *)uniqueChangeSetFileName;
+ (NSString *)defaultTemporaryFolder;
+ (void)setDefaultTemporaryFolder:(NSString *)aPath;

- (NSString *)incomingChangesFolder;
- (NSString *)uniqueIncomingChangeSetPath;

- (MCChangeSet *)newAutoreleasedChangeSetAtPath:(NSString *)filePath parentID:(NSString *)aUUID;
- (MCChangeSet *)newAutoreleasedChangeSetAtPath:(NSString *)filePath;

+ (NSUInteger)numberOfChangeSetsInDirectory:(NSString *)dir;
+ (NSArray *)changeSetNamesInDirectory:(NSString *)dir;

+ (MCChangeSet *)changeSetAtPath:(NSString *)filePath;

+ (NSString *)pathToNewestChangeSetInDirectory:(NSString *)dir;
+ (MCChangeSet *)newestChangeSetForDirectory:(NSString *)dir;

+ (NSString *)pathToOldestChangeSetInDirectory:(NSString *)dir;
+ (MCChangeSet *)oldestChangeSetForDirectory:(NSString *)dir;


+ (void)removeZeroByteFilesInDirectory:(NSString *)dir;

+ (BOOL)coalesceChangeSetsInDirectory:(NSString *)dir
                     archiveDirectory:(NSString *)archiveDir
                                error:(NSError **)error;


- (NSString *)archiveChangeSetFolder;

- (void)createChangeSetDirectories;

// IMPORTANT: Call this after initialization (creates directories and/or opens existing change sets)
- (void)configureChangeSets;

- (void)deleteChangeSet:(MCChangeSet *)changes;
- (void)deleteAllTemporaryChangeSets;
- (void)deleteAllChangeSets;

- (void)reconcileChangeSet:(MCChangeSet *)setA
			 withChangeSet:(MCChangeSet *)setB
				 toFolderA:(NSString *)folderA
				 toFolderB:(NSString *)folderB
				   resultA:(MCChangeSet **)setAPrimePtr
				   resultB:(MCChangeSet **)setBPrimePtr;

- (void)cleanup;

@end

@interface MCChangeManager (MCChangeManagerSubclass)

- (NSString *)clientID;

@end


